-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
		self.p1 = Citadels.GetPlayer(1)
    
    if not self.loaded then
      self.active = false
			self.waveActive = false
      self.attNo = 0
      self.timer = 150
			self.handleTimer = 15
			self.index = 0
    end
        
    self.offAtt1:LinkToTarget("attOff1")
    self.offAtt2:LinkToTarget("attOff2")
		self.wavesDestroyed:LinkToTarget("victory")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      self.timer = 180
      self.attNo = self.attNo + 1
      SendAttack(self)
    end	
	end 
	
	if self.waveActive then
		td = Timer:GetTimeDiff()
		self.handleTimer = self.handleTimer - td
    
		if self.handleTimer <= 0 then
			HandleWave(self)
			self.handleTimer = 4
		end  
	end	
end

function SendAttack(self)
  if self.attNo == 1 then
		self.offAtt1:TriggerAllTargets()
  elseif self.attNo == 2 then
    self.offAtt2:TriggerAllTargets()
  end
	self.waveActive = true
	self.active = false
end

function HandleWave(self)
	attUnits = self.p1:CheckUnitsCount(6, 1)
	
	if not attUnits then
		if self.attNo == 2 then
			self.wavesDestroyed:TriggerAllTargets()
		end		
    self.waveActive = false
		self.active = true
		self.handleTimer = 20
		self.player = nil
  end  
end

function OnTrigger(self, source, target)
  Debug:Log("Source = " .. source .. " !!! Target = " .. target)
  if target == "handlerActivate" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  CreateTriggerSources(self)
	  self.loaded = true
	  self.active = ar:Read()
		self.waveActive = ar:Read()
	  self.attNo = ar:Read()
		self.timer = ar:Read()
		self.handleTimer = ar:Read()
		self.index = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
		ar:Write(self.waveActive)
    ar:Write(self.attNo)
    ar:Write(self.timer)
		ar:Write(self.handleTimer)
		ar:Write(self.index)
  end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("handlerActivate")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("offAtt1")
  self:AddTriggerSource("offAtt2")
	self:AddTriggerSource("wavesDestroyed")
end
